/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations.AuthRegistrationsCredentialListMapping;

public class AuthRegistrationsCredentialListMappingFetcher
extends Fetcher<AuthRegistrationsCredentialListMapping> {
    private String pathAccountSid;
    private final String pathDomainSid;
    private final String pathSid;

    public AuthRegistrationsCredentialListMappingFetcher(String pathDomainSid, String pathSid) {
        this.pathDomainSid = pathDomainSid;
        this.pathSid = pathSid;
    }

    public AuthRegistrationsCredentialListMappingFetcher(String pathAccountSid, String pathDomainSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathDomainSid = pathDomainSid;
        this.pathSid = pathSid;
    }

    @Override
    public AuthRegistrationsCredentialListMapping fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/Domains/" + this.pathDomainSid + "/Auth/Registrations/CredentialListMappings/" + this.pathSid + ".json");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthRegistrationsCredentialListMapping fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AuthRegistrationsCredentialListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }
}

