/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.PaymentCreator;
import com.twilio.rest.api.v2010.account.call.PaymentUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Payment
extends Resource {
    private static final long serialVersionUID = 264986398146032L;
    private final String accountSid;
    private final String callSid;
    private final String sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static PaymentCreator creator(String pathAccountSid, String pathCallSid, String idempotencyKey, URI statusCallback) {
        return new PaymentCreator(pathAccountSid, pathCallSid, idempotencyKey, statusCallback);
    }

    public static PaymentCreator creator(String pathCallSid, String idempotencyKey, URI statusCallback) {
        return new PaymentCreator(pathCallSid, idempotencyKey, statusCallback);
    }

    public static PaymentUpdater updater(String pathAccountSid, String pathCallSid, String pathSid, String idempotencyKey, URI statusCallback) {
        return new PaymentUpdater(pathAccountSid, pathCallSid, pathSid, idempotencyKey, statusCallback);
    }

    public static PaymentUpdater updater(String pathCallSid, String pathSid, String idempotencyKey, URI statusCallback) {
        return new PaymentUpdater(pathCallSid, pathSid, idempotencyKey, statusCallback);
    }

    public static Payment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Payment)objectMapper.readValue(json, Payment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Payment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Payment)objectMapper.readValue(json, Payment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Payment(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment other = (Payment)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.callSid, this.sid, this.dateCreated, this.dateUpdated, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("callSid", (Object)this.callSid).add("sid", (Object)this.sid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("uri", (Object)this.uri).toString();
    }

    public static enum Status {
        COMPLETE("complete"),
        CANCEL("cancel");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Capture {
        PAYMENT_CARD_NUMBER("payment-card-number"),
        EXPIRATION_DATE("expiration-date"),
        SECURITY_CODE("security-code"),
        POSTAL_CODE("postal-code"),
        BANK_ROUTING_NUMBER("bank-routing-number"),
        BANK_ACCOUNT_NUMBER("bank-account-number");

        private final String value;

        private Capture(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Capture forValue(String value) {
            return (Capture)Promoter.enumFromString((String)value, (Enum[])Capture.values());
        }
    }

    public static enum TokenType {
        ONE_TIME("one-time"),
        REUSABLE("reusable");

        private final String value;

        private TokenType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TokenType forValue(String value) {
            return (TokenType)Promoter.enumFromString((String)value, (Enum[])TokenType.values());
        }
    }

    public static enum BankAccountType {
        CONSUMER_CHECKING("consumer-checking"),
        CONSUMER_SAVINGS("consumer-savings"),
        COMMERCIAL_CHECKING("commercial-checking");

        private final String value;

        private BankAccountType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BankAccountType forValue(String value) {
            return (BankAccountType)Promoter.enumFromString((String)value, (Enum[])BankAccountType.values());
        }
    }

    public static enum PaymentMethod {
        CREDIT_CARD("credit-card"),
        ACH_DEBIT("ach-debit");

        private final String value;

        private PaymentMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static PaymentMethod forValue(String value) {
            return (PaymentMethod)Promoter.enumFromString((String)value, (Enum[])PaymentMethod.values());
        }
    }
}

