/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.ConferenceFetcher;
import com.twilio.rest.api.v2010.account.ConferenceReader;
import com.twilio.rest.api.v2010.account.ConferenceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conference
extends Resource {
    private static final long serialVersionUID = 11011722206180L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String apiVersion;
    private final String friendlyName;
    private final String region;
    private final String sid;
    private final Status status;
    private final String uri;
    private final Map<String, String> subresourceUris;
    private final ReasonConferenceEnded reasonConferenceEnded;
    private final String callSidEndingConference;

    public static ConferenceFetcher fetcher(String pathAccountSid, String pathSid) {
        return new ConferenceFetcher(pathAccountSid, pathSid);
    }

    public static ConferenceFetcher fetcher(String pathSid) {
        return new ConferenceFetcher(pathSid);
    }

    public static ConferenceReader reader(String pathAccountSid) {
        return new ConferenceReader(pathAccountSid);
    }

    public static ConferenceReader reader() {
        return new ConferenceReader();
    }

    public static ConferenceUpdater updater(String pathAccountSid, String pathSid) {
        return new ConferenceUpdater(pathAccountSid, pathSid);
    }

    public static ConferenceUpdater updater(String pathSid) {
        return new ConferenceUpdater(pathSid);
    }

    public static Conference fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Conference)objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Conference fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Conference)objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Conference(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="region") String region, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="uri") String uri, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="reason_conference_ended") ReasonConferenceEnded reasonConferenceEnded, @JsonProperty(value="call_sid_ending_conference") String callSidEndingConference) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.apiVersion = apiVersion;
        this.friendlyName = friendlyName;
        this.region = region;
        this.sid = sid;
        this.status = status;
        this.uri = uri;
        this.subresourceUris = subresourceUris;
        this.reasonConferenceEnded = reasonConferenceEnded;
        this.callSidEndingConference = callSidEndingConference;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final ReasonConferenceEnded getReasonConferenceEnded() {
        return this.reasonConferenceEnded;
    }

    public final String getCallSidEndingConference() {
        return this.callSidEndingConference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conference other = (Conference)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.region, other.region) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.uri, other.uri) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals((Object)this.reasonConferenceEnded, (Object)other.reasonConferenceEnded) && Objects.equals(this.callSidEndingConference, other.callSidEndingConference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.apiVersion, this.friendlyName, this.region, this.sid, this.status, this.uri, this.subresourceUris, this.reasonConferenceEnded, this.callSidEndingConference});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("apiVersion", (Object)this.apiVersion).add("friendlyName", (Object)this.friendlyName).add("region", (Object)this.region).add("sid", (Object)this.sid).add("status", (Object)this.status).add("uri", (Object)this.uri).add("subresourceUris", this.subresourceUris).add("reasonConferenceEnded", (Object)this.reasonConferenceEnded).add("callSidEndingConference", (Object)this.callSidEndingConference).toString();
    }

    public static enum ReasonConferenceEnded {
        CONFERENCE_ENDED_VIA_API("conference-ended-via-api"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_LEFT("participant-with-end-conference-on-exit-left"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_KICKED("participant-with-end-conference-on-exit-kicked"),
        LAST_PARTICIPANT_KICKED("last-participant-kicked"),
        LAST_PARTICIPANT_LEFT("last-participant-left");

        private final String value;

        private ReasonConferenceEnded(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ReasonConferenceEnded forValue(String value) {
            return (ReasonConferenceEnded)Promoter.enumFromString((String)value, (Enum[])ReasonConferenceEnded.values());
        }
    }

    public static enum UpdateStatus {
        COMPLETED("completed");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum Status {
        INIT("init"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

