/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.exception.ApiException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;
import org.apache.http.Header;

public class Response {
    private final InputStream stream;
    private final String content;
    private final int statusCode;
    private final Header[] headers;

    public Response(String content, int statusCode) {
        this(content, statusCode, null);
    }

    public Response(String content, int statusCode, Header[] headers) {
        this.stream = null;
        this.content = content;
        this.statusCode = statusCode;
        this.headers = headers;
    }

    public Response(InputStream stream, int statusCode) {
        this(stream, statusCode, null);
    }

    public Response(InputStream stream, int statusCode, Header[] headers) {
        this.stream = stream;
        this.content = null;
        this.statusCode = statusCode;
        this.headers = headers;
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.stream != null) {
            Scanner scanner = new Scanner(this.stream, "UTF-8").useDelimiter("\\A");
            if (!scanner.hasNext()) {
                return "";
            }
            String data = scanner.next();
            scanner.close();
            return data;
        }
        return "";
    }

    public InputStream getStream() {
        if (this.stream != null) {
            return this.stream;
        }
        try {
            return new ByteArrayInputStream(this.content.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ApiException("UTF-8 encoding not supported", e);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Header[] getHeaders() {
        return this.headers;
    }
}

