/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Room;

public class RoomUpdater
extends Updater<Room> {
    private final String pathSid;
    private final Room.RoomStatus status;

    public RoomUpdater(String pathSid, Room.RoomStatus status) {
        this.pathSid = pathSid;
        this.status = status;
    }

    @Override
    public Room update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Room update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Room.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

