/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Room;
import java.net.URI;
import java.util.List;

public class RoomCreator
extends Creator<Room> {
    private Boolean enableTurn;
    private Room.RoomType type;
    private String uniqueName;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private Integer maxParticipants;
    private Boolean recordParticipantsOnConnect;
    private List<Room.VideoCodec> videoCodecs;
    private String mediaRegion;

    public RoomCreator setEnableTurn(Boolean enableTurn) {
        this.enableTurn = enableTurn;
        return this;
    }

    public RoomCreator setType(Room.RoomType type) {
        this.type = type;
        return this;
    }

    public RoomCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public RoomCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public RoomCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public RoomCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public RoomCreator setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    public RoomCreator setRecordParticipantsOnConnect(Boolean recordParticipantsOnConnect) {
        this.recordParticipantsOnConnect = recordParticipantsOnConnect;
        return this;
    }

    public RoomCreator setVideoCodecs(List<Room.VideoCodec> videoCodecs) {
        this.videoCodecs = videoCodecs;
        return this;
    }

    public RoomCreator setVideoCodecs(Room.VideoCodec videoCodecs) {
        return this.setVideoCodecs(Promoter.listOfOne(videoCodecs));
    }

    public RoomCreator setMediaRegion(String mediaRegion) {
        this.mediaRegion = mediaRegion;
        return this;
    }

    @Override
    public Room create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/Rooms");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Room creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Room.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.enableTurn != null) {
            request.addPostParam("EnableTurn", this.enableTurn.toString());
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.maxParticipants != null) {
            request.addPostParam("MaxParticipants", this.maxParticipants.toString());
        }
        if (this.recordParticipantsOnConnect != null) {
            request.addPostParam("RecordParticipantsOnConnect", this.recordParticipantsOnConnect.toString());
        }
        if (this.videoCodecs != null) {
            for (Room.VideoCodec prop : this.videoCodecs) {
                request.addPostParam("VideoCodecs", prop.toString());
            }
        }
        if (this.mediaRegion != null) {
            request.addPostParam("MediaRegion", this.mediaRegion);
        }
    }
}

