/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.ServiceCreator;
import com.twilio.rest.sync.v1.ServiceDeleter;
import com.twilio.rest.sync.v1.ServiceFetcher;
import com.twilio.rest.sync.v1.ServiceReader;
import com.twilio.rest.sync.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 2344628544363L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final URI webhookUrl;
    private final Boolean webhooksFromRestEnabled;
    private final Boolean reachabilityWebhooksEnabled;
    private final Boolean aclEnabled;
    private final Boolean reachabilityDebouncingEnabled;
    private final Integer reachabilityDebouncingWindow;
    private final Map<String, String> links;

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceCreator creator() {
        return new ServiceCreator();
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="webhook_url") URI webhookUrl, @JsonProperty(value="webhooks_from_rest_enabled") Boolean webhooksFromRestEnabled, @JsonProperty(value="reachability_webhooks_enabled") Boolean reachabilityWebhooksEnabled, @JsonProperty(value="acl_enabled") Boolean aclEnabled, @JsonProperty(value="reachability_debouncing_enabled") Boolean reachabilityDebouncingEnabled, @JsonProperty(value="reachability_debouncing_window") Integer reachabilityDebouncingWindow, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.webhookUrl = webhookUrl;
        this.webhooksFromRestEnabled = webhooksFromRestEnabled;
        this.reachabilityWebhooksEnabled = reachabilityWebhooksEnabled;
        this.aclEnabled = aclEnabled;
        this.reachabilityDebouncingEnabled = reachabilityDebouncingEnabled;
        this.reachabilityDebouncingWindow = reachabilityDebouncingWindow;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public final Boolean getWebhooksFromRestEnabled() {
        return this.webhooksFromRestEnabled;
    }

    public final Boolean getReachabilityWebhooksEnabled() {
        return this.reachabilityWebhooksEnabled;
    }

    public final Boolean getAclEnabled() {
        return this.aclEnabled;
    }

    public final Boolean getReachabilityDebouncingEnabled() {
        return this.reachabilityDebouncingEnabled;
    }

    public final Integer getReachabilityDebouncingWindow() {
        return this.reachabilityDebouncingWindow;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.webhooksFromRestEnabled, other.webhooksFromRestEnabled) && Objects.equals(this.reachabilityWebhooksEnabled, other.reachabilityWebhooksEnabled) && Objects.equals(this.aclEnabled, other.aclEnabled) && Objects.equals(this.reachabilityDebouncingEnabled, other.reachabilityDebouncingEnabled) && Objects.equals(this.reachabilityDebouncingWindow, other.reachabilityDebouncingWindow) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.uniqueName, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.url, this.webhookUrl, this.webhooksFromRestEnabled, this.reachabilityWebhooksEnabled, this.aclEnabled, this.reachabilityDebouncingEnabled, this.reachabilityDebouncingWindow, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("webhookUrl", (Object)this.webhookUrl).add("webhooksFromRestEnabled", (Object)this.webhooksFromRestEnabled).add("reachabilityWebhooksEnabled", (Object)this.reachabilityWebhooksEnabled).add("aclEnabled", (Object)this.aclEnabled).add("reachabilityDebouncingEnabled", (Object)this.reachabilityDebouncingEnabled).add("reachabilityDebouncingWindow", (Object)this.reachabilityDebouncingWindow).add("links", this.links).toString();
    }
}

