/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.pricing.v1.voice.CountryFetcher;
import com.twilio.rest.pricing.v1.voice.CountryReader;
import com.twilio.type.InboundCallPrice;
import com.twilio.type.OutboundPrefixPrice;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Country
extends Resource {
    private static final long serialVersionUID = 270847470775437L;
    private final String country;
    private final String isoCountry;
    private final List<OutboundPrefixPrice> outboundPrefixPrices;
    private final List<InboundCallPrice> inboundCallPrices;
    private final Currency priceUnit;
    private final URI url;

    public static CountryReader reader() {
        return new CountryReader();
    }

    public static CountryFetcher fetcher(String pathIsoCountry) {
        return new CountryFetcher(pathIsoCountry);
    }

    public static Country fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Country fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Country(@JsonProperty(value="country") String country, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="outbound_prefix_prices") List<OutboundPrefixPrice> outboundPrefixPrices, @JsonProperty(value="inbound_call_prices") List<InboundCallPrice> inboundCallPrices, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="url") URI url) {
        this.country = country;
        this.isoCountry = isoCountry;
        this.outboundPrefixPrices = outboundPrefixPrices;
        this.inboundCallPrices = inboundCallPrices;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<OutboundPrefixPrice> getOutboundPrefixPrices() {
        return this.outboundPrefixPrices;
    }

    public final List<InboundCallPrice> getInboundCallPrices() {
        return this.inboundCallPrices;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country other = (Country)o;
        return Objects.equals(this.country, other.country) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.outboundPrefixPrices, other.outboundPrefixPrices) && Objects.equals(this.inboundCallPrices, other.inboundCallPrices) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.country, this.isoCountry, this.outboundPrefixPrices, this.inboundCallPrices, this.priceUnit, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("country", (Object)this.country).add("isoCountry", (Object)this.isoCountry).add("outboundPrefixPrices", this.outboundPrefixPrices).add("inboundCallPrices", this.inboundCallPrices).add("priceUnit", (Object)this.priceUnit).add("url", (Object)this.url).toString();
    }
}

