/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.RatePlan;

public class RatePlanReader
extends Reader<RatePlan> {
    @Override
    public ResourceSet<RatePlan> read(TwilioRestClient client) {
        return new ResourceSet<RatePlan>(this, client, this.firstPage(client));
    }

    @Override
    public Page<RatePlan> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/wireless/RatePlans");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RatePlan> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RatePlan> nextPage(Page<RatePlan> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RatePlan> previousPage(Page<RatePlan> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<RatePlan> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RatePlan read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("rate_plans", response.getContent(), RatePlan.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

