/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.deployedDevices.fleet.CertificateCreator;
import com.twilio.rest.preview.deployedDevices.fleet.CertificateDeleter;
import com.twilio.rest.preview.deployedDevices.fleet.CertificateFetcher;
import com.twilio.rest.preview.deployedDevices.fleet.CertificateReader;
import com.twilio.rest.preview.deployedDevices.fleet.CertificateUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Certificate
extends Resource {
    private static final long serialVersionUID = 78866906209311L;
    private final String sid;
    private final URI url;
    private final String friendlyName;
    private final String fleetSid;
    private final String accountSid;
    private final String deviceSid;
    private final String thumbprint;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static CertificateFetcher fetcher(String pathFleetSid, String pathSid) {
        return new CertificateFetcher(pathFleetSid, pathSid);
    }

    public static CertificateDeleter deleter(String pathFleetSid, String pathSid) {
        return new CertificateDeleter(pathFleetSid, pathSid);
    }

    public static CertificateCreator creator(String pathFleetSid, String certificateData) {
        return new CertificateCreator(pathFleetSid, certificateData);
    }

    public static CertificateReader reader(String pathFleetSid) {
        return new CertificateReader(pathFleetSid);
    }

    public static CertificateUpdater updater(String pathFleetSid, String pathSid) {
        return new CertificateUpdater(pathFleetSid, pathSid);
    }

    public static Certificate fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Certificate)objectMapper.readValue(json, Certificate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Certificate fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Certificate)objectMapper.readValue(json, Certificate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Certificate(@JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="device_sid") String deviceSid, @JsonProperty(value="thumbprint") String thumbprint, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.url = url;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.accountSid = accountSid;
        this.deviceSid = deviceSid;
        this.thumbprint = thumbprint;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getThumbprint() {
        return this.thumbprint;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Certificate other = (Certificate)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.deviceSid, other.deviceSid) && Objects.equals(this.thumbprint, other.thumbprint) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.url, this.friendlyName, this.fleetSid, this.accountSid, this.deviceSid, this.thumbprint, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("url", (Object)this.url).add("friendlyName", (Object)this.friendlyName).add("fleetSid", (Object)this.fleetSid).add("accountSid", (Object)this.accountSid).add("deviceSid", (Object)this.deviceSid).add("thumbprint", (Object)this.thumbprint).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).toString();
    }
}

