/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentType;

public class SupportingDocumentTypeFetcher
extends Fetcher<SupportingDocumentType> {
    private final String pathSid;

    public SupportingDocumentTypeFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public SupportingDocumentType fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/SupportingDocumentTypes/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SupportingDocumentType fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SupportingDocumentType.fromJson(response.getStream(), client.getObjectMapper());
    }
}

