/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Bundle;
import java.net.URI;

public class BundleCreator
extends Creator<Bundle> {
    private final String friendlyName;
    private final String email;
    private URI statusCallback;
    private String regulationSid;
    private String isoCountry;
    private Bundle.EndUserType endUserType;
    private String numberType;

    public BundleCreator(String friendlyName, String email) {
        this.friendlyName = friendlyName;
        this.email = email;
    }

    public BundleCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public BundleCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public BundleCreator setRegulationSid(String regulationSid) {
        this.regulationSid = regulationSid;
        return this;
    }

    public BundleCreator setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public BundleCreator setEndUserType(Bundle.EndUserType endUserType) {
        this.endUserType = endUserType;
        return this;
    }

    public BundleCreator setNumberType(String numberType) {
        this.numberType = numberType;
        return this;
    }

    @Override
    public Bundle create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/Bundles");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bundle creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Bundle.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.regulationSid != null) {
            request.addPostParam("RegulationSid", this.regulationSid);
        }
        if (this.isoCountry != null) {
            request.addPostParam("IsoCountry", this.isoCountry);
        }
        if (this.endUserType != null) {
            request.addPostParam("EndUserType", this.endUserType.toString());
        }
        if (this.numberType != null) {
            request.addPostParam("NumberType", this.numberType);
        }
    }
}

