/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.configuration.NotificationFetcher;
import com.twilio.rest.conversations.v1.service.configuration.NotificationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
extends Resource {
    private static final long serialVersionUID = 28053260690009L;
    private final String accountSid;
    private final String chatServiceSid;
    private final Map<String, Object> newMessage;
    private final Map<String, Object> addedToConversation;
    private final Map<String, Object> removedFromConversation;
    private final Boolean logEnabled;
    private final URI url;

    public static NotificationUpdater updater(String pathChatServiceSid) {
        return new NotificationUpdater(pathChatServiceSid);
    }

    public static NotificationFetcher fetcher(String pathChatServiceSid) {
        return new NotificationFetcher(pathChatServiceSid);
    }

    public static Notification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Notification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Notification(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="new_message") Map<String, Object> newMessage, @JsonProperty(value="added_to_conversation") Map<String, Object> addedToConversation, @JsonProperty(value="removed_from_conversation") Map<String, Object> removedFromConversation, @JsonProperty(value="log_enabled") Boolean logEnabled, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.newMessage = newMessage;
        this.addedToConversation = addedToConversation;
        this.removedFromConversation = removedFromConversation;
        this.logEnabled = logEnabled;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final Map<String, Object> getNewMessage() {
        return this.newMessage;
    }

    public final Map<String, Object> getAddedToConversation() {
        return this.addedToConversation;
    }

    public final Map<String, Object> getRemovedFromConversation() {
        return this.removedFromConversation;
    }

    public final Boolean getLogEnabled() {
        return this.logEnabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification other = (Notification)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.newMessage, other.newMessage) && Objects.equals(this.addedToConversation, other.addedToConversation) && Objects.equals(this.removedFromConversation, other.removedFromConversation) && Objects.equals(this.logEnabled, other.logEnabled) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.chatServiceSid, this.newMessage, this.addedToConversation, this.removedFromConversation, this.logEnabled, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("chatServiceSid", (Object)this.chatServiceSid).add("newMessage", this.newMessage).add("addedToConversation", this.addedToConversation).add("removedFromConversation", this.removedFromConversation).add("logEnabled", (Object)this.logEnabled).add("url", (Object)this.url).toString();
    }
}

