/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.BindingDeleter;
import com.twilio.rest.conversations.v1.service.BindingFetcher;
import com.twilio.rest.conversations.v1.service.BindingReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Binding
extends Resource {
    private static final long serialVersionUID = 252683481132009L;
    private final String sid;
    private final String accountSid;
    private final String chatServiceSid;
    private final String credentialSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String endpoint;
    private final String identity;
    private final BindingType bindingType;
    private final List<String> messageTypes;
    private final URI url;

    public static BindingDeleter deleter(String pathChatServiceSid, String pathSid) {
        return new BindingDeleter(pathChatServiceSid, pathSid);
    }

    public static BindingFetcher fetcher(String pathChatServiceSid, String pathSid) {
        return new BindingFetcher(pathChatServiceSid, pathSid);
    }

    public static BindingReader reader(String pathChatServiceSid) {
        return new BindingReader(pathChatServiceSid);
    }

    public static Binding fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Binding)objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Binding fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Binding)objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Binding(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="credential_sid") String credentialSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="identity") String identity, @JsonProperty(value="binding_type") BindingType bindingType, @JsonProperty(value="message_types") List<String> messageTypes, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.credentialSid = credentialSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.endpoint = endpoint;
        this.identity = identity;
        this.bindingType = bindingType;
        this.messageTypes = messageTypes;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getCredentialSid() {
        return this.credentialSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final BindingType getBindingType() {
        return this.bindingType;
    }

    public final List<String> getMessageTypes() {
        return this.messageTypes;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding other = (Binding)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.credentialSid, other.credentialSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.identity, other.identity) && Objects.equals((Object)this.bindingType, (Object)other.bindingType) && Objects.equals(this.messageTypes, other.messageTypes) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.chatServiceSid, this.credentialSid, this.dateCreated, this.dateUpdated, this.endpoint, this.identity, this.bindingType, this.messageTypes, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("chatServiceSid", (Object)this.chatServiceSid).add("credentialSid", (Object)this.credentialSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("endpoint", (Object)this.endpoint).add("identity", (Object)this.identity).add("bindingType", (Object)this.bindingType).add("messageTypes", this.messageTypes).add("url", (Object)this.url).toString();
    }

    public static enum BindingType {
        APN("apn"),
        GCM("gcm"),
        FCM("fcm");

        private final String value;

        private BindingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BindingType forValue(String value) {
            return (BindingType)Promoter.enumFromString((String)value, (Enum[])BindingType.values());
        }
    }
}

