/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.user;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.user.UserChannel;

public class UserChannelReader
extends Reader<UserChannel> {
    private final String pathServiceSid;
    private final String pathUserSid;

    public UserChannelReader(String pathServiceSid, String pathUserSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathUserSid = pathUserSid;
    }

    @Override
    public ResourceSet<UserChannel> read(TwilioRestClient client) {
        return new ResourceSet<UserChannel>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UserChannel> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CHAT.toString(), "/v1/Services/" + this.pathServiceSid + "/Users/" + this.pathUserSid + "/Channels");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserChannel> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserChannel> nextPage(Page<UserChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserChannel> previousPage(Page<UserChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<UserChannel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserChannel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("channels", response.getContent(), UserChannel.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

