/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddress;

public class IpAddressFetcher
extends Fetcher<IpAddress> {
    private String pathAccountSid;
    private final String pathIpAccessControlListSid;
    private final String pathSid;

    public IpAddressFetcher(String pathIpAccessControlListSid, String pathSid) {
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    public IpAddressFetcher(String pathAccountSid, String pathIpAccessControlListSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    @Override
    public IpAddress fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/IpAccessControlLists/" + this.pathIpAccessControlListSid + "/IpAddresses/" + this.pathSid + ".json");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAddress fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return IpAddress.fromJson(response.getStream(), client.getObjectMapper());
    }
}

