/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.OutgoingCallerId;
import com.twilio.type.PhoneNumber;

public class OutgoingCallerIdReader
extends Reader<OutgoingCallerId> {
    private String pathAccountSid;
    private PhoneNumber phoneNumber;
    private String friendlyName;

    public OutgoingCallerIdReader() {
    }

    public OutgoingCallerIdReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public OutgoingCallerIdReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public OutgoingCallerIdReader setPhoneNumber(String phoneNumber) {
        return this.setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    public OutgoingCallerIdReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public ResourceSet<OutgoingCallerId> read(TwilioRestClient client) {
        return new ResourceSet<OutgoingCallerId>(this, client, this.firstPage(client));
    }

    @Override
    public Page<OutgoingCallerId> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/OutgoingCallerIds.json");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<OutgoingCallerId> getPage(String targetUrl, TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<OutgoingCallerId> nextPage(Page<OutgoingCallerId> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<OutgoingCallerId> previousPage(Page<OutgoingCallerId> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<OutgoingCallerId> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OutgoingCallerId read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("outgoing_caller_ids", response.getContent(), OutgoingCallerId.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

