/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.ConnectAppDeleter;
import com.twilio.rest.api.v2010.account.ConnectAppFetcher;
import com.twilio.rest.api.v2010.account.ConnectAppReader;
import com.twilio.rest.api.v2010.account.ConnectAppUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectApp
extends Resource {
    private static final long serialVersionUID = 269497828076419L;
    private final String accountSid;
    private final URI authorizeRedirectUrl;
    private final String companyName;
    private final HttpMethod deauthorizeCallbackMethod;
    private final URI deauthorizeCallbackUrl;
    private final String description;
    private final String friendlyName;
    private final URI homepageUrl;
    private final List<Permission> permissions;
    private final String sid;
    private final String uri;

    public static ConnectAppFetcher fetcher(String pathAccountSid, String pathSid) {
        return new ConnectAppFetcher(pathAccountSid, pathSid);
    }

    public static ConnectAppFetcher fetcher(String pathSid) {
        return new ConnectAppFetcher(pathSid);
    }

    public static ConnectAppUpdater updater(String pathAccountSid, String pathSid) {
        return new ConnectAppUpdater(pathAccountSid, pathSid);
    }

    public static ConnectAppUpdater updater(String pathSid) {
        return new ConnectAppUpdater(pathSid);
    }

    public static ConnectAppReader reader(String pathAccountSid) {
        return new ConnectAppReader(pathAccountSid);
    }

    public static ConnectAppReader reader() {
        return new ConnectAppReader();
    }

    public static ConnectAppDeleter deleter(String pathAccountSid, String pathSid) {
        return new ConnectAppDeleter(pathAccountSid, pathSid);
    }

    public static ConnectAppDeleter deleter(String pathSid) {
        return new ConnectAppDeleter(pathSid);
    }

    public static ConnectApp fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ConnectApp)objectMapper.readValue(json, ConnectApp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ConnectApp fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ConnectApp)objectMapper.readValue(json, ConnectApp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ConnectApp(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="authorize_redirect_url") URI authorizeRedirectUrl, @JsonProperty(value="company_name") String companyName, @JsonProperty(value="deauthorize_callback_method") HttpMethod deauthorizeCallbackMethod, @JsonProperty(value="deauthorize_callback_url") URI deauthorizeCallbackUrl, @JsonProperty(value="description") String description, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="homepage_url") URI homepageUrl, @JsonProperty(value="permissions") List<Permission> permissions, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.authorizeRedirectUrl = authorizeRedirectUrl;
        this.companyName = companyName;
        this.deauthorizeCallbackMethod = deauthorizeCallbackMethod;
        this.deauthorizeCallbackUrl = deauthorizeCallbackUrl;
        this.description = description;
        this.friendlyName = friendlyName;
        this.homepageUrl = homepageUrl;
        this.permissions = permissions;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final URI getAuthorizeRedirectUrl() {
        return this.authorizeRedirectUrl;
    }

    public final String getCompanyName() {
        return this.companyName;
    }

    public final HttpMethod getDeauthorizeCallbackMethod() {
        return this.deauthorizeCallbackMethod;
    }

    public final URI getDeauthorizeCallbackUrl() {
        return this.deauthorizeCallbackUrl;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final URI getHomepageUrl() {
        return this.homepageUrl;
    }

    public final List<Permission> getPermissions() {
        return this.permissions;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectApp other = (ConnectApp)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.authorizeRedirectUrl, other.authorizeRedirectUrl) && Objects.equals(this.companyName, other.companyName) && Objects.equals((Object)this.deauthorizeCallbackMethod, (Object)other.deauthorizeCallbackMethod) && Objects.equals(this.deauthorizeCallbackUrl, other.deauthorizeCallbackUrl) && Objects.equals(this.description, other.description) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.homepageUrl, other.homepageUrl) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.authorizeRedirectUrl, this.companyName, this.deauthorizeCallbackMethod, this.deauthorizeCallbackUrl, this.description, this.friendlyName, this.homepageUrl, this.permissions, this.sid, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("authorizeRedirectUrl", (Object)this.authorizeRedirectUrl).add("companyName", (Object)this.companyName).add("deauthorizeCallbackMethod", (Object)this.deauthorizeCallbackMethod).add("deauthorizeCallbackUrl", (Object)this.deauthorizeCallbackUrl).add("description", (Object)this.description).add("friendlyName", (Object)this.friendlyName).add("homepageUrl", (Object)this.homepageUrl).add("permissions", this.permissions).add("sid", (Object)this.sid).add("uri", (Object)this.uri).toString();
    }

    public static enum Permission {
        GET_ALL("get-all"),
        POST_ALL("post-all");

        private final String value;

        private Permission(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Permission forValue(String value) {
            return (Permission)Promoter.enumFromString((String)value, (Enum[])Permission.values());
        }
    }
}

