/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Verification;

public class VerificationUpdater
extends Updater<Verification> {
    private final String pathServiceSid;
    private final String pathSid;
    private final Verification.Status status;

    public VerificationUpdater(String pathServiceSid, String pathSid, Verification.Status status) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    @Override
    public Verification update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Verifications/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Verification update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Verification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

