/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Form;

public class FormFetcher
extends Fetcher<Form> {
    private final Form.FormTypes pathFormType;

    public FormFetcher(Form.FormTypes pathFormType) {
        this.pathFormType = pathFormType;
    }

    @Override
    public Form fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), "/v2/Forms/" + (Object)((Object)this.pathFormType) + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Form fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Form.fromJson(response.getStream(), client.getObjectMapper());
    }
}

