/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.Execution;

public class ExecutionUpdater
extends Updater<Execution> {
    private final String pathFlowSid;
    private final String pathSid;
    private final Execution.Status status;

    public ExecutionUpdater(String pathFlowSid, String pathSid, Execution.Status status) {
        this.pathFlowSid = pathFlowSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    @Override
    public Execution update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), "/v2/Flows/" + this.pathFlowSid + "/Executions/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Execution update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Execution.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

