/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.Flow;

public class FlowReader
extends Reader<Flow> {
    @Override
    public ResourceSet<Flow> read(TwilioRestClient client) {
        return new ResourceSet<Flow>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Flow> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Flow> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Flow> nextPage(Page<Flow> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Flow> previousPage(Page<Flow> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Flow> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Flow read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("flows", response.getContent(), Flow.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

