/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.Task;
import java.net.URI;
import java.util.Map;

public class TaskCreator
extends Creator<Task> {
    private final String pathAssistantSid;
    private final String uniqueName;
    private String friendlyName;
    private Map<String, Object> actions;
    private URI actionsUrl;

    public TaskCreator(String pathAssistantSid, String uniqueName) {
        this.pathAssistantSid = pathAssistantSid;
        this.uniqueName = uniqueName;
    }

    public TaskCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskCreator setActions(Map<String, Object> actions) {
        this.actions = actions;
        return this;
    }

    public TaskCreator setActionsUrl(URI actionsUrl) {
        this.actionsUrl = actionsUrl;
        return this;
    }

    public TaskCreator setActionsUrl(String actionsUrl) {
        return this.setActionsUrl(Promoter.uriFromString(actionsUrl));
    }

    @Override
    public Task create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Tasks");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.actions != null) {
            request.addPostParam("Actions", Converter.mapToJson(this.actions));
        }
        if (this.actionsUrl != null) {
            request.addPostParam("ActionsUrl", this.actionsUrl.toString());
        }
    }
}

