/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.BrandsInformationFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandsInformation
extends Resource {
    private static final long serialVersionUID = 89883061153774L;
    private final DateTime updateTime;
    private final URI fileLink;
    private final String fileLinkTtlInSeconds;
    private final URI url;

    public static BrandsInformationFetcher fetcher() {
        return new BrandsInformationFetcher();
    }

    public static BrandsInformation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (BrandsInformation)objectMapper.readValue(json, BrandsInformation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandsInformation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (BrandsInformation)objectMapper.readValue(json, BrandsInformation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandsInformation(@JsonProperty(value="update_time") String updateTime, @JsonProperty(value="file_link") URI fileLink, @JsonProperty(value="file_link_ttl_in_seconds") String fileLinkTtlInSeconds, @JsonProperty(value="url") URI url) {
        this.updateTime = DateConverter.iso8601DateTimeFromString(updateTime);
        this.fileLink = fileLink;
        this.fileLinkTtlInSeconds = fileLinkTtlInSeconds;
        this.url = url;
    }

    public final DateTime getUpdateTime() {
        return this.updateTime;
    }

    public final URI getFileLink() {
        return this.fileLink;
    }

    public final String getFileLinkTtlInSeconds() {
        return this.fileLinkTtlInSeconds;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandsInformation other = (BrandsInformation)o;
        return Objects.equals(this.updateTime, other.updateTime) && Objects.equals(this.fileLink, other.fileLink) && Objects.equals(this.fileLinkTtlInSeconds, other.fileLinkTtlInSeconds) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.updateTime, this.fileLink, this.fileLinkTtlInSeconds, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("updateTime", (Object)this.updateTime).add("fileLink", (Object)this.fileLink).add("fileLinkTtlInSeconds", (Object)this.fileLinkTtlInSeconds).add("url", (Object)this.url).toString();
    }
}

