/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.EvaluationCreator;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.EvaluationFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.EvaluationReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Evaluation
extends Resource {
    private static final long serialVersionUID = 256422056466941L;
    private final String sid;
    private final String accountSid;
    private final String regulationSid;
    private final String bundleSid;
    private final Status status;
    private final List<Map<String, Object>> results;
    private final DateTime dateCreated;
    private final URI url;

    public static EvaluationCreator creator(String pathBundleSid) {
        return new EvaluationCreator(pathBundleSid);
    }

    public static EvaluationReader reader(String pathBundleSid) {
        return new EvaluationReader(pathBundleSid);
    }

    public static EvaluationFetcher fetcher(String pathBundleSid, String pathSid) {
        return new EvaluationFetcher(pathBundleSid, pathSid);
    }

    public static Evaluation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Evaluation)objectMapper.readValue(json, Evaluation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Evaluation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Evaluation)objectMapper.readValue(json, Evaluation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Evaluation(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="regulation_sid") String regulationSid, @JsonProperty(value="bundle_sid") String bundleSid, @JsonProperty(value="status") Status status, @JsonProperty(value="results") List<Map<String, Object>> results, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.regulationSid = regulationSid;
        this.bundleSid = bundleSid;
        this.status = status;
        this.results = results;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRegulationSid() {
        return this.regulationSid;
    }

    public final String getBundleSid() {
        return this.bundleSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Evaluation other = (Evaluation)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.regulationSid, other.regulationSid) && Objects.equals(this.bundleSid, other.bundleSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.results, other.results) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.regulationSid, this.bundleSid, this.status, this.results, this.dateCreated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("regulationSid", (Object)this.regulationSid).add("bundleSid", (Object)this.bundleSid).add("status", (Object)this.status).add("results", this.results).add("dateCreated", (Object)this.dateCreated).add("url", (Object)this.url).toString();
    }

    public static enum Status {
        COMPLIANT("compliant"),
        NONCOMPLIANT("noncompliant");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

