/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Bundle;

public class BundleReader
extends Reader<Bundle> {
    private Bundle.Status status;
    private String friendlyName;
    private String regulationSid;
    private String isoCountry;
    private String numberType;

    public BundleReader setStatus(Bundle.Status status) {
        this.status = status;
        return this;
    }

    public BundleReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public BundleReader setRegulationSid(String regulationSid) {
        this.regulationSid = regulationSid;
        return this;
    }

    public BundleReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public BundleReader setNumberType(String numberType) {
        this.numberType = numberType;
        return this;
    }

    @Override
    public ResourceSet<Bundle> read(TwilioRestClient client) {
        return new ResourceSet<Bundle>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Bundle> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/Bundles");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bundle> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bundle> nextPage(Page<Bundle> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bundle> previousPage(Page<Bundle> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Bundle> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bundle read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), Bundle.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.regulationSid != null) {
            request.addQueryParam("RegulationSid", this.regulationSid);
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.numberType != null) {
            request.addQueryParam("NumberType", this.numberType);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

