/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Fetcher;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Deactivations;
import org.joda.time.LocalDate;

public class DeactivationsFetcher
extends Fetcher<Deactivations> {
    private LocalDate date;

    public DeactivationsFetcher setDate(LocalDate date) {
        this.date = date;
        return this;
    }

    @Override
    public Deactivations fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), "/v1/Deactivations");
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deactivations fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Deactivations.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.date != null) {
            request.addQueryParam("Date", DateConverter.dateStringFromLocalDate(this.date));
        }
    }
}

