/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.sink;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.sink.SinkValidate;

public class SinkValidateCreator
extends Creator<SinkValidate> {
    private final String pathSid;
    private final String testId;

    public SinkValidateCreator(String pathSid, String testId) {
        this.pathSid = pathSid;
        this.testId = testId;
    }

    @Override
    public SinkValidate create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.EVENTS.toString(), "/v1/Sinks/" + this.pathSid + "/Validate");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SinkValidate creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SinkValidate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.testId != null) {
            request.addPostParam("TestId", this.testId);
        }
    }
}

