/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.Participant;

public class ParticipantDeleter
extends Deleter<Participant> {
    private final String pathConversationSid;
    private final String pathSid;
    private Participant.WebhookEnabledType xTwilioWebhookEnabled;

    public ParticipantDeleter(String pathConversationSid, String pathSid) {
        this.pathConversationSid = pathConversationSid;
        this.pathSid = pathSid;
    }

    public ParticipantDeleter setXTwilioWebhookEnabled(Participant.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.CONVERSATIONS.toString(), "/v1/Conversations/" + this.pathConversationSid + "/Participants/" + this.pathSid + "");
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

