/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.Domain;
import java.net.URI;

public class DomainUpdater
extends Updater<Domain> {
    private String pathAccountSid;
    private final String pathSid;
    private String friendlyName;
    private HttpMethod voiceFallbackMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceMethod;
    private HttpMethod voiceStatusCallbackMethod;
    private URI voiceStatusCallbackUrl;
    private URI voiceUrl;
    private Boolean sipRegistration;
    private String domainName;
    private Boolean emergencyCallingEnabled;
    private Boolean secure;
    private String byocTrunkSid;
    private String emergencyCallerSid;

    public DomainUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public DomainUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public DomainUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DomainUpdater setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public DomainUpdater setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public DomainUpdater setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public DomainUpdater setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public DomainUpdater setVoiceStatusCallbackMethod(HttpMethod voiceStatusCallbackMethod) {
        this.voiceStatusCallbackMethod = voiceStatusCallbackMethod;
        return this;
    }

    public DomainUpdater setVoiceStatusCallbackUrl(URI voiceStatusCallbackUrl) {
        this.voiceStatusCallbackUrl = voiceStatusCallbackUrl;
        return this;
    }

    public DomainUpdater setVoiceStatusCallbackUrl(String voiceStatusCallbackUrl) {
        return this.setVoiceStatusCallbackUrl(Promoter.uriFromString(voiceStatusCallbackUrl));
    }

    public DomainUpdater setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public DomainUpdater setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    public DomainUpdater setSipRegistration(Boolean sipRegistration) {
        this.sipRegistration = sipRegistration;
        return this;
    }

    public DomainUpdater setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public DomainUpdater setEmergencyCallingEnabled(Boolean emergencyCallingEnabled) {
        this.emergencyCallingEnabled = emergencyCallingEnabled;
        return this;
    }

    public DomainUpdater setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public DomainUpdater setByocTrunkSid(String byocTrunkSid) {
        this.byocTrunkSid = byocTrunkSid;
        return this;
    }

    public DomainUpdater setEmergencyCallerSid(String emergencyCallerSid) {
        this.emergencyCallerSid = emergencyCallerSid;
        return this;
    }

    @Override
    public Domain update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/Domains/" + this.pathSid + ".json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Domain update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Domain.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceStatusCallbackMethod != null) {
            request.addPostParam("VoiceStatusCallbackMethod", this.voiceStatusCallbackMethod.toString());
        }
        if (this.voiceStatusCallbackUrl != null) {
            request.addPostParam("VoiceStatusCallbackUrl", this.voiceStatusCallbackUrl.toString());
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
        if (this.sipRegistration != null) {
            request.addPostParam("SipRegistration", this.sipRegistration.toString());
        }
        if (this.domainName != null) {
            request.addPostParam("DomainName", this.domainName);
        }
        if (this.emergencyCallingEnabled != null) {
            request.addPostParam("EmergencyCallingEnabled", this.emergencyCallingEnabled.toString());
        }
        if (this.secure != null) {
            request.addPostParam("Secure", this.secure.toString());
        }
        if (this.byocTrunkSid != null) {
            request.addPostParam("ByocTrunkSid", this.byocTrunkSid);
        }
        if (this.emergencyCallerSid != null) {
            request.addPostParam("EmergencyCallerSid", this.emergencyCallerSid);
        }
    }
}

