/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.message;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.message.Media;

public class MediaFetcher
extends Fetcher<Media> {
    private String pathAccountSid;
    private final String pathMessageSid;
    private final String pathSid;

    public MediaFetcher(String pathMessageSid, String pathSid) {
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    public MediaFetcher(String pathAccountSid, String pathMessageSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    @Override
    public Media fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages/" + this.pathMessageSid + "/Media/" + this.pathSid + ".json");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Media fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Media.fromJson(response.getStream(), client.getObjectMapper());
    }
}

