/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1.credential;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.credential.PublicKey;

public class PublicKeyCreator
extends Creator<PublicKey> {
    private final String publicKey;
    private String friendlyName;
    private String accountSid;

    public PublicKeyCreator(String publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKeyCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public PublicKeyCreator setAccountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    @Override
    public PublicKey create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.ACCOUNTS.toString(), "/v1/Credentials/PublicKeys");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PublicKey creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return PublicKey.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.publicKey != null) {
            request.addPostParam("PublicKey", this.publicKey.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.accountSid != null) {
            request.addPostParam("AccountSid", this.accountSid);
        }
    }
}

