/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.Reservation;

public class ReservationReader
extends Reader<Reservation> {
    private final String pathWorkspaceSid;
    private final String pathWorkerSid;
    private Reservation.Status reservationStatus;

    public ReservationReader(String pathWorkspaceSid, String pathWorkerSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkerSid = pathWorkerSid;
    }

    public ReservationReader setReservationStatus(Reservation.Status reservationStatus) {
        this.reservationStatus = reservationStatus;
        return this;
    }

    @Override
    public ResourceSet<Reservation> read(TwilioRestClient client) {
        return new ResourceSet<Reservation>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Reservation> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/" + this.pathWorkerSid + "/Reservations", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Reservation> nextPage(Page<Reservation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Reservation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Reservation read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("reservations", response.getContent(), Reservation.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.reservationStatus != null) {
            request.addQueryParam("ReservationStatus", this.reservationStatus.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

