/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueStatistics;
import org.joda.time.DateTime;

public class TaskQueueStatisticsFetcher
extends Fetcher<TaskQueueStatistics> {
    private final String pathWorkspaceSid;
    private final String pathTaskQueueSid;
    private DateTime endDate;
    private Integer minutes;
    private DateTime startDate;

    public TaskQueueStatisticsFetcher(String pathWorkspaceSid, String pathTaskQueueSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathTaskQueueSid = pathTaskQueueSid;
    }

    public TaskQueueStatisticsFetcher setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public TaskQueueStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public TaskQueueStatisticsFetcher setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Override
    public TaskQueueStatistics fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/TaskQueues/" + this.pathTaskQueueSid + "/Statistics", client.getRegion());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueueStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TaskQueueStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
    }
}

