/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.Channel;
import java.util.List;

public class ChannelReader
extends Reader<Channel> {
    private final String pathServiceSid;
    private List<Channel.ChannelType> type;

    public ChannelReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public ChannelReader setType(List<Channel.ChannelType> type) {
        this.type = type;
        return this;
    }

    public ChannelReader setType(Channel.ChannelType type) {
        return this.setType(Promoter.listOfOne(type));
    }

    @Override
    public ResourceSet<Channel> read(TwilioRestClient client) {
        return new ResourceSet<Channel>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Channel> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CHAT.toString(), "/v1/Services/" + this.pathServiceSid + "/Channels", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Channel> nextPage(Page<Channel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CHAT.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Channel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("channels", response.getContent(), Channel.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.type != null) {
            for (Channel.ChannelType prop : this.type) {
                request.addQueryParam("Type", prop.toString());
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

