/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.AuthorizedConnectApp;

public class AuthorizedConnectAppFetcher
extends Fetcher<AuthorizedConnectApp> {
    private String pathAccountSid;
    private final String pathConnectAppSid;

    public AuthorizedConnectAppFetcher(String pathConnectAppSid) {
        this.pathConnectAppSid = pathConnectAppSid;
    }

    public AuthorizedConnectAppFetcher(String pathAccountSid, String pathConnectAppSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConnectAppSid = pathConnectAppSid;
    }

    @Override
    public AuthorizedConnectApp fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/AuthorizedConnectApps/" + this.pathConnectAppSid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizedConnectApp fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return AuthorizedConnectApp.fromJson(response.getStream(), client.getObjectMapper());
    }
}

