/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.monitor.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.monitor.v1.Alert;

public class AlertFetcher
extends Fetcher<Alert> {
    private final String pathSid;

    public AlertFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Alert fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.MONITOR.toString(), "/v1/Alerts/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Alert fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Alert.fromJson(response.getStream(), client.getObjectMapper());
    }
}

