/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v2.service.ChannelCreator;
import com.twilio.rest.ipmessaging.v2.service.ChannelDeleter;
import com.twilio.rest.ipmessaging.v2.service.ChannelFetcher;
import com.twilio.rest.ipmessaging.v2.service.ChannelReader;
import com.twilio.rest.ipmessaging.v2.service.ChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Channel
extends Resource {
    private static final long serialVersionUID = 267741172679383L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String friendlyName;
    private final String uniqueName;
    private final String attributes;
    private final ChannelType type;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String createdBy;
    private final Integer membersCount;
    private final Integer messagesCount;
    private final URI url;
    private final Map<String, String> links;

    public static ChannelFetcher fetcher(String pathServiceSid, String pathSid) {
        return new ChannelFetcher(pathServiceSid, pathSid);
    }

    public static ChannelDeleter deleter(String pathServiceSid, String pathSid) {
        return new ChannelDeleter(pathServiceSid, pathSid);
    }

    public static ChannelCreator creator(String pathServiceSid) {
        return new ChannelCreator(pathServiceSid);
    }

    public static ChannelReader reader(String pathServiceSid) {
        return new ChannelReader(pathServiceSid);
    }

    public static ChannelUpdater updater(String pathServiceSid, String pathSid) {
        return new ChannelUpdater(pathServiceSid, pathSid);
    }

    public static Channel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Channel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Channel(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="type") ChannelType type, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy, @JsonProperty(value="members_count") Integer membersCount, @JsonProperty(value="messages_count") Integer messagesCount, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
        this.attributes = attributes;
        this.type = type;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
        this.membersCount = membersCount;
        this.messagesCount = messagesCount;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final ChannelType getType() {
        return this.type;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public final Integer getMembersCount() {
        return this.membersCount;
    }

    public final Integer getMessagesCount() {
        return this.messagesCount;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel other = (Channel)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.attributes, other.attributes) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.membersCount, other.membersCount) && Objects.equals(this.messagesCount, other.messagesCount) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.friendlyName, this.uniqueName, this.attributes, this.type, this.dateCreated, this.dateUpdated, this.createdBy, this.membersCount, this.messagesCount, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("friendlyName", (Object)this.friendlyName).add("uniqueName", (Object)this.uniqueName).add("attributes", (Object)this.attributes).add("type", (Object)this.type).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("createdBy", (Object)this.createdBy).add("membersCount", (Object)this.membersCount).add("messagesCount", (Object)this.messagesCount).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum ChannelType {
        PUBLIC("public"),
        PRIVATE("private");

        private final String value;

        private ChannelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelType forValue(String value) {
            return (ChannelType)Promoter.enumFromString((String)value, (Enum[])ChannelType.values());
        }
    }
}

