/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddress;

public class IpAddressUpdater
extends Updater<IpAddress> {
    private String pathAccountSid;
    private final String pathIpAccessControlListSid;
    private final String pathSid;
    private String ipAddress;
    private String friendlyName;

    public IpAddressUpdater(String pathIpAccessControlListSid, String pathSid) {
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    public IpAddressUpdater(String pathAccountSid, String pathIpAccessControlListSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
        this.pathSid = pathSid;
    }

    public IpAddressUpdater setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public IpAddressUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public IpAddress update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/IpAccessControlLists/" + this.pathIpAccessControlListSid + "/IpAddresses/" + this.pathSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAddress update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return IpAddress.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipAddress != null) {
            request.addPostParam("IpAddress", this.ipAddress);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

