/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.AuthorizedConnectAppFetcher;
import com.twilio.rest.api.v2010.account.AuthorizedConnectAppReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthorizedConnectApp
extends Resource {
    private static final long serialVersionUID = 77011834457452L;
    private final String accountSid;
    private final String connectAppCompanyName;
    private final String connectAppDescription;
    private final String connectAppFriendlyName;
    private final URI connectAppHomepageUrl;
    private final String connectAppSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final List<Permission> permissions;
    private final String uri;

    public static AuthorizedConnectAppFetcher fetcher(String pathAccountSid, String pathConnectAppSid) {
        return new AuthorizedConnectAppFetcher(pathAccountSid, pathConnectAppSid);
    }

    public static AuthorizedConnectAppFetcher fetcher(String pathConnectAppSid) {
        return new AuthorizedConnectAppFetcher(pathConnectAppSid);
    }

    public static AuthorizedConnectAppReader reader(String pathAccountSid) {
        return new AuthorizedConnectAppReader(pathAccountSid);
    }

    public static AuthorizedConnectAppReader reader() {
        return new AuthorizedConnectAppReader();
    }

    public static AuthorizedConnectApp fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AuthorizedConnectApp)objectMapper.readValue(json, AuthorizedConnectApp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AuthorizedConnectApp fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AuthorizedConnectApp)objectMapper.readValue(json, AuthorizedConnectApp.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AuthorizedConnectApp(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="connect_app_company_name") String connectAppCompanyName, @JsonProperty(value="connect_app_description") String connectAppDescription, @JsonProperty(value="connect_app_friendly_name") String connectAppFriendlyName, @JsonProperty(value="connect_app_homepage_url") URI connectAppHomepageUrl, @JsonProperty(value="connect_app_sid") String connectAppSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="permissions") List<Permission> permissions, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.connectAppCompanyName = connectAppCompanyName;
        this.connectAppDescription = connectAppDescription;
        this.connectAppFriendlyName = connectAppFriendlyName;
        this.connectAppHomepageUrl = connectAppHomepageUrl;
        this.connectAppSid = connectAppSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.permissions = permissions;
        this.uri = uri;
    }

    public final String getSid() {
        return this.getConnectAppSid();
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConnectAppCompanyName() {
        return this.connectAppCompanyName;
    }

    public final String getConnectAppDescription() {
        return this.connectAppDescription;
    }

    public final String getConnectAppFriendlyName() {
        return this.connectAppFriendlyName;
    }

    public final URI getConnectAppHomepageUrl() {
        return this.connectAppHomepageUrl;
    }

    public final String getConnectAppSid() {
        return this.connectAppSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final List<Permission> getPermissions() {
        return this.permissions;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizedConnectApp other = (AuthorizedConnectApp)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.connectAppCompanyName, other.connectAppCompanyName) && Objects.equals(this.connectAppDescription, other.connectAppDescription) && Objects.equals(this.connectAppFriendlyName, other.connectAppFriendlyName) && Objects.equals(this.connectAppHomepageUrl, other.connectAppHomepageUrl) && Objects.equals(this.connectAppSid, other.connectAppSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.connectAppCompanyName, this.connectAppDescription, this.connectAppFriendlyName, this.connectAppHomepageUrl, this.connectAppSid, this.dateCreated, this.dateUpdated, this.permissions, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("connectAppCompanyName", (Object)this.connectAppCompanyName).add("connectAppDescription", (Object)this.connectAppDescription).add("connectAppFriendlyName", (Object)this.connectAppFriendlyName).add("connectAppHomepageUrl", (Object)this.connectAppHomepageUrl).add("connectAppSid", (Object)this.connectAppSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("permissions", this.permissions).add("uri", (Object)this.uri).toString();
    }

    public static enum Permission {
        GET_ALL("get-all"),
        POST_ALL("post-all");

        private final String value;

        private Permission(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Permission forValue(String value) {
            return (Permission)Promoter.enumFromString((String)value, (Enum[])Permission.values());
        }
    }
}

