/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.google.common.collect.Maps;
import com.twilio.twiml.TwiML;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

@XmlRootElement(name="Pause")
public class Pause
extends TwiML {
    @XmlAttribute
    private final Integer length;
    @XmlAnyAttribute
    private Map<QName, String> options;

    private Pause() {
        this(new Builder());
    }

    private Pause(Builder b) {
        this.length = b.length;
        this.options = Maps.newHashMap((Map)b.options);
    }

    public Integer getLength() {
        return this.length;
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        Set<QName> keys = this.options.keySet();
        for (QName key : keys) {
            convertedMap.put(key.getNamespaceURI(), this.options.get(key));
        }
        return convertedMap;
    }

    public static class Builder {
        private Integer length;
        private Map<QName, String> options = Maps.newHashMap();

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder options(String key, String value) {
            this.options.put(new QName(key), value);
            return this;
        }

        public Pause build() {
            return new Pause(this);
        }
    }
}

