/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.Account;

public class AccountFetcher
extends Fetcher<Account> {
    private String pathSid;

    public AccountFetcher() {
    }

    public AccountFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Account fetch(TwilioRestClient client) {
        this.pathSid = this.pathSid == null ? client.getAccountSid() : this.pathSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathSid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Account.fromJson(response.getStream(), client.getObjectMapper());
    }
}

