/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.validation;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import com.twilio.http.HttpMethod;
import com.twilio.jwt.Jwt;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.message.BasicHeader;

public class ValidationToken
extends Jwt {
    private static final HashFunction HASH_FUNCTION = Hashing.sha256();
    private static final String CTY = "twilio-pkrv;v=1";
    private static final String NEW_LINE = "\n";
    private final String accountSid;
    private final String credentialSid;
    private final String signingKeySid;
    private final String method;
    private final String uri;
    private final String queryString;
    private final Header[] headers;
    private final List<String> signedHeaders;
    private final String requestBody;
    private static Function<Header[], Map<String, List<String>>> COMBINE_HEADERS = new Function<Header[], Map<String, List<String>>>(){

        public Map<String, List<String>> apply(Header[] headers) {
            HashMap<String, List<String>> combinedHeaders = new HashMap<String, List<String>>();
            for (Header header : headers) {
                if (combinedHeaders.containsKey(header.getName())) {
                    ((List)combinedHeaders.get(header.getName())).add(header.getValue());
                    continue;
                }
                combinedHeaders.put(header.getName(), Lists.newArrayList((Object[])new String[]{header.getValue()}));
            }
            return combinedHeaders;
        }
    };
    private static Function<Header[], Header[]> LOWERCASE_KEYS = new Function<Header[], Header[]>(){

        public Header[] apply(Header[] headers) {
            Header[] lowercaseHeaders = new Header[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                lowercaseHeaders[i] = new BasicHeader(headers[i].getName().toLowerCase(), headers[i].getValue());
            }
            return lowercaseHeaders;
        }
    };
    private static Function<String, String> LOWERCASE_STRING = new Function<String, String>(){

        public String apply(String s) {
            return s.toLowerCase();
        }
    };

    private ValidationToken(Builder b) {
        super(SignatureAlgorithm.RS256, b.privateKey, b.credentialSid, new Date(new Date().getTime() + (long)(b.ttl * 1000)));
        this.accountSid = b.accountSid;
        this.credentialSid = b.credentialSid;
        this.signingKeySid = b.signingKeySid;
        this.method = b.method;
        this.uri = b.uri;
        this.queryString = b.queryString;
        this.headers = b.headers;
        this.signedHeaders = b.signedHeaders;
        this.requestBody = b.requestBody;
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cty", CTY);
        headers.put("kid", this.credentialSid);
        return headers;
    }

    @Override
    public Map<String, Object> getClaims() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("iss", this.signingKeySid);
        payload.put("sub", this.accountSid);
        Collections.sort(this.signedHeaders);
        List lowercaseSignedHeaders = Lists.transform(this.signedHeaders, LOWERCASE_STRING);
        String includedHeaders = Joiner.on((String)";").join((Iterable)lowercaseSignedHeaders);
        payload.put("hrh", includedHeaders);
        StringBuilder signature = new StringBuilder();
        signature.append(this.method).append(NEW_LINE);
        signature.append(this.uri).append(NEW_LINE);
        Object[] queryArgs = this.queryString.split("&");
        Arrays.sort(queryArgs);
        String sortedQueryString = Joiner.on((String)"&").join(queryArgs);
        signature.append(sortedQueryString).append(NEW_LINE);
        Header[] lowercaseHeaders = (Header[])LOWERCASE_KEYS.apply((Object)this.headers);
        Map combinedHeaders = (Map)COMBINE_HEADERS.apply((Object)lowercaseHeaders);
        for (String header : lowercaseSignedHeaders) {
            String lowercase = header.toLowerCase().trim();
            if (!combinedHeaders.containsKey(lowercase)) continue;
            List values = (List)combinedHeaders.get(lowercase);
            Collections.sort(values);
            signature.append(lowercase).append(":").append(Joiner.on((char)',').join((Iterable)values)).append(NEW_LINE);
        }
        signature.append(NEW_LINE);
        signature.append(includedHeaders).append(NEW_LINE);
        if (!Strings.isNullOrEmpty((String)this.requestBody)) {
            String hashedPayload = HASH_FUNCTION.hashString((CharSequence)this.requestBody, Charsets.UTF_8).toString();
            signature.append(hashedPayload);
        }
        String hashedSignature = HASH_FUNCTION.hashString((CharSequence)signature.toString(), Charsets.UTF_8).toString();
        payload.put("rqh", hashedSignature);
        return payload;
    }

    public static ValidationToken fromHttpRequest(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey, HttpRequest request, List<String> signedHeaders) throws IOException {
        Builder builder = new Builder(accountSid, credentialSid, signingKeySid, privateKey);
        String method = request.getRequestLine().getMethod();
        builder.method(method);
        String uri = request.getRequestLine().getUri();
        if (uri.contains("?")) {
            String[] uriParts = uri.split("\\?");
            builder.uri(uriParts[0]);
            builder.queryString(uriParts[1]);
        } else {
            builder.uri(uri);
        }
        builder.headers(request.getAllHeaders());
        builder.signedHeaders(signedHeaders);
        if (HttpMethod.POST.toString().equals(method.toUpperCase())) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            builder.requestBody(CharStreams.toString((Readable)new InputStreamReader(entity.getContent(), Charsets.UTF_8)));
        }
        return builder.build();
    }

    public static class Builder {
        private String accountSid;
        private String credentialSid;
        private String signingKeySid;
        private PrivateKey privateKey;
        private String method;
        private String uri;
        private String queryString = "";
        private Header[] headers;
        private List<String> signedHeaders = Collections.emptyList();
        private String requestBody = "";
        private int ttl = 300;

        public Builder(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey) {
            this.accountSid = accountSid;
            this.credentialSid = credentialSid;
            this.signingKeySid = signingKeySid;
            this.privateKey = privateKey;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder headers(Header[] headers) {
            this.headers = headers;
            return this;
        }

        public Builder signedHeaders(List<String> signedHeaders) {
            this.signedHeaders = signedHeaders;
            return this;
        }

        public Builder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public ValidationToken build() {
            return new ValidationToken(this);
        }
    }
}

