/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.google.common.collect.Range;
import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Conference;
import org.joda.time.LocalDate;

public class ConferenceReader
extends Reader<Conference> {
    private String pathAccountSid;
    private LocalDate absoluteDateCreated;
    private Range<LocalDate> rangeDateCreated;
    private LocalDate absoluteDateUpdated;
    private Range<LocalDate> rangeDateUpdated;
    private String friendlyName;
    private Conference.Status status;

    public ConferenceReader() {
    }

    public ConferenceReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public ConferenceReader setDateCreated(LocalDate absoluteDateCreated) {
        this.rangeDateCreated = null;
        this.absoluteDateCreated = absoluteDateCreated;
        return this;
    }

    public ConferenceReader setDateCreated(Range<LocalDate> rangeDateCreated) {
        this.absoluteDateCreated = null;
        this.rangeDateCreated = rangeDateCreated;
        return this;
    }

    public ConferenceReader setDateUpdated(LocalDate absoluteDateUpdated) {
        this.rangeDateUpdated = null;
        this.absoluteDateUpdated = absoluteDateUpdated;
        return this;
    }

    public ConferenceReader setDateUpdated(Range<LocalDate> rangeDateUpdated) {
        this.absoluteDateUpdated = null;
        this.rangeDateUpdated = rangeDateUpdated;
        return this;
    }

    public ConferenceReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConferenceReader setStatus(Conference.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public ResourceSet<Conference> read(TwilioRestClient client) {
        return new ResourceSet<Conference>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Conference> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> nextPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Conference> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("conferences", response.getContent(), Conference.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.absoluteDateCreated != null) {
            request.addQueryParam("DateCreated", this.absoluteDateCreated.toString("yyyy-MM-dd"));
        } else if (this.rangeDateCreated != null) {
            request.addQueryDateRange("DateCreated", this.rangeDateCreated);
        }
        if (this.absoluteDateUpdated != null) {
            request.addQueryParam("DateUpdated", this.absoluteDateUpdated.toString("yyyy-MM-dd"));
        } else if (this.rangeDateUpdated != null) {
            request.addQueryDateRange("DateUpdated", this.rangeDateUpdated);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

