/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Component;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedResourceEndpointMBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ResourceEndpoint")
public abstract class ResourceEndpoint
extends ProcessorEndpoint
implements ManagedResourceEndpointMBean {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile byte[] buffer;
    @UriPath(description="Path to the resource. You can prefix with: classpath, file, http, ref, or bean. classpath, file and http loads the resource using these protocols (classpath is default). ref will lookup the resource in the registry. bean will call a method on a bean to be used as the resource. For bean you can specify the method name after dot, eg bean:myBean.myMethod.")
    @Metadata(required=true)
    private String resourceUri;
    @UriParam(defaultValue="false", description="Sets whether to use resource content cache or not")
    private boolean contentCache;

    public ResourceEndpoint() {
    }

    public ResourceEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsInputStream() throws IOException {
        if (this.isContentCache()) {
            ResourceEndpoint resourceEndpoint = this;
            synchronized (resourceEndpoint) {
                if (this.buffer == null) {
                    this.log.debug("Reading resource: {} into the content cache", (Object)this.resourceUri);
                    try (InputStream is = this.getResourceAsInputStreamWithoutCache();){
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        IOHelper.copy((InputStream)IOHelper.buffered((InputStream)is), (OutputStream)bos);
                        this.buffer = bos.toByteArray();
                    }
                }
            }
            this.log.debug("Using resource: {} from the content cache", (Object)this.resourceUri);
            return new ByteArrayInputStream(this.buffer);
        }
        return this.getResourceAsInputStreamWithoutCache();
    }

    protected InputStream getResourceAsInputStreamWithoutCache() throws IOException {
        return this.loadResource(this.resourceUri);
    }

    protected InputStream loadResource(String uri) throws IOException {
        return ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), uri);
    }

    @ManagedAttribute(description="Whether the resource is cached")
    public boolean isContentCache() {
        return this.contentCache;
    }

    @ManagedOperation(description="Clears the cached resource, forcing to re-load the resource on next request")
    public void clearContentCache() {
        this.log.debug("Clearing resource: {} from the content cache", (Object)this.resourceUri);
        this.buffer = null;
    }

    public boolean isContentCacheCleared() {
        return this.buffer == null;
    }

    @ManagedAttribute(description="Camel context ID")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName() {
        return this.getCamelContext().getManagementName();
    }

    @ManagedAttribute(description="Endpoint service state")
    public String getState() {
        return this.getStatus().name();
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

