/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.IpRecord;

public class IpRecordCreator
extends Creator<IpRecord> {
    private final String ipAddress;
    private String friendlyName;
    private Integer cidrPrefixLength;

    public IpRecordCreator(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public IpRecordCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public IpRecordCreator setCidrPrefixLength(Integer cidrPrefixLength) {
        this.cidrPrefixLength = cidrPrefixLength;
        return this;
    }

    @Override
    public IpRecord create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), "/v1/IpRecords");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpRecord creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return IpRecord.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipAddress != null) {
            request.addPostParam("IpAddress", this.ipAddress);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.cidrPrefixLength != null) {
            request.addPostParam("CidrPrefixLength", this.cidrPrefixLength.toString());
        }
    }
}

