/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Service;
import java.util.Map;

public class ServiceUpdater
extends Updater<Service> {
    private final String pathSid;
    private String friendlyName;
    private Integer codeLength;
    private Boolean lookupEnabled;
    private Boolean skipSmsToLandlines;
    private Boolean dtmfInputRequired;
    private String ttsName;
    private Boolean psd2Enabled;
    private Boolean doNotShareWarningEnabled;
    private Boolean customCodeEnabled;
    private Map<String, Object> push;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
        return this;
    }

    public ServiceUpdater setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
        return this;
    }

    public ServiceUpdater setSkipSmsToLandlines(Boolean skipSmsToLandlines) {
        this.skipSmsToLandlines = skipSmsToLandlines;
        return this;
    }

    public ServiceUpdater setDtmfInputRequired(Boolean dtmfInputRequired) {
        this.dtmfInputRequired = dtmfInputRequired;
        return this;
    }

    public ServiceUpdater setTtsName(String ttsName) {
        this.ttsName = ttsName;
        return this;
    }

    public ServiceUpdater setPsd2Enabled(Boolean psd2Enabled) {
        this.psd2Enabled = psd2Enabled;
        return this;
    }

    public ServiceUpdater setDoNotShareWarningEnabled(Boolean doNotShareWarningEnabled) {
        this.doNotShareWarningEnabled = doNotShareWarningEnabled;
        return this;
    }

    public ServiceUpdater setCustomCodeEnabled(Boolean customCodeEnabled) {
        this.customCodeEnabled = customCodeEnabled;
        return this;
    }

    public ServiceUpdater setPush(Map<String, Object> push) {
        this.push = push;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.codeLength != null) {
            request.addPostParam("CodeLength", this.codeLength.toString());
        }
        if (this.lookupEnabled != null) {
            request.addPostParam("LookupEnabled", this.lookupEnabled.toString());
        }
        if (this.skipSmsToLandlines != null) {
            request.addPostParam("SkipSmsToLandlines", this.skipSmsToLandlines.toString());
        }
        if (this.dtmfInputRequired != null) {
            request.addPostParam("DtmfInputRequired", this.dtmfInputRequired.toString());
        }
        if (this.ttsName != null) {
            request.addPostParam("TtsName", this.ttsName);
        }
        if (this.psd2Enabled != null) {
            request.addPostParam("Psd2Enabled", this.psd2Enabled.toString());
        }
        if (this.doNotShareWarningEnabled != null) {
            request.addPostParam("DoNotShareWarningEnabled", this.doNotShareWarningEnabled.toString());
        }
        if (this.customCodeEnabled != null) {
            request.addPostParam("CustomCodeEnabled", this.customCodeEnabled.toString());
        }
        if (this.push != null) {
            request.addPostParam("Push", Converter.mapToJson(this.push));
        }
    }
}

