/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerChannel;

public class WorkerChannelReader
extends Reader<WorkerChannel> {
    private final String pathWorkspaceSid;
    private final String pathWorkerSid;

    public WorkerChannelReader(String pathWorkspaceSid, String pathWorkerSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkerSid = pathWorkerSid;
    }

    @Override
    public ResourceSet<WorkerChannel> read(TwilioRestClient client) {
        return new ResourceSet<WorkerChannel>(this, client, this.firstPage(client));
    }

    @Override
    public Page<WorkerChannel> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/" + this.pathWorkerSid + "/Channels");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<WorkerChannel> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<WorkerChannel> nextPage(Page<WorkerChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<WorkerChannel> previousPage(Page<WorkerChannel> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<WorkerChannel> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkerChannel read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("channels", response.getContent(), WorkerChannel.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

