/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;

public class TaskUpdater
extends Updater<Task> {
    private final String pathWorkspaceSid;
    private final String pathSid;
    private String attributes;
    private Task.Status assignmentStatus;
    private String reason;
    private Integer priority;
    private String taskChannel;

    public TaskUpdater(String pathWorkspaceSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    public TaskUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public TaskUpdater setAssignmentStatus(Task.Status assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public TaskUpdater setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public TaskUpdater setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskUpdater setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    @Override
    public Task update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Tasks/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.assignmentStatus != null) {
            request.addPostParam("AssignmentStatus", this.assignmentStatus.toString());
        }
        if (this.reason != null) {
            request.addPostParam("Reason", this.reason);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.taskChannel != null) {
            request.addPostParam("TaskChannel", this.taskChannel);
        }
    }
}

