/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannel;

public class TaskChannelCreator
extends Creator<TaskChannel> {
    private final String pathWorkspaceSid;
    private final String friendlyName;
    private final String uniqueName;
    private Boolean channelOptimizedRouting;

    public TaskChannelCreator(String pathWorkspaceSid, String friendlyName, String uniqueName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
    }

    public TaskChannelCreator setChannelOptimizedRouting(Boolean channelOptimizedRouting) {
        this.channelOptimizedRouting = channelOptimizedRouting;
        return this;
    }

    @Override
    public TaskChannel create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/TaskChannels");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskChannel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return TaskChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.channelOptimizedRouting != null) {
            request.addPostParam("ChannelOptimizedRouting", this.channelOptimizedRouting.toString());
        }
    }
}

